// IRSummary.cpp : implementation file
//

/*
	Copyright (C) 2010 Graham Dixon

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "stdafx.h"
//#include "IRScope.h"
#include "IRScopeDlg.h"
#include "IRSummary.h"
#include <math.h>

// CIRSummary dialog

CIRSummary::CIRSummary(CWnd* pParent /*=NULL*/)
	: CDialog(CIRSummary::IDD, pParent)
	, m_dlg(NULL)
	, m_bWrap(FALSE)
{
}

CIRSummary::~CIRSummary()
{
}

void CIRSummary::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_IR_SUMMARY, m_cSummary);
	DDX_Check(pDX, IDC_CHECK_WRAP, m_bWrap);
}


BEGIN_MESSAGE_MAP(CIRSummary, CDialog)
	ON_BN_CLICKED(IDC_BN_SAVEAS, &CIRSummary::OnBnClickedBnSaveas)
	ON_WM_SIZE()
	ON_WM_SIZING()
	ON_BN_CLICKED(IDC_CHECK_WRAP, &CIRSummary::OnBnClickedCheckWrap)
END_MESSAGE_MAP()

BEGIN_EASYSIZE_MAP(CIRSummary)
	EASYSIZE(IDC_IR_SUMMARY, ES_BORDER, ES_BORDER, ES_BORDER, ES_BORDER, 0)
	EASYSIZE(IDC_BN_SAVEAS, ES_KEEPSIZE, ES_KEEPSIZE, ES_BORDER, ES_BORDER,0)
	EASYSIZE(IDCANCEL, ES_KEEPSIZE, ES_KEEPSIZE, ES_BORDER, ES_BORDER,0)
	EASYSIZE(IDC_STATIC_SUMMARY, ES_BORDER, ES_KEEPSIZE, ES_KEEPSIZE, ES_BORDER,0)
	EASYSIZE(IDC_CHECK_WRAP, ES_BORDER, ES_KEEPSIZE, ES_KEEPSIZE, ES_BORDER,0)
END_EASYSIZE_MAP

// CIRSummary message handlers

BOOL CIRSummary::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	int	iLogX = ::GetDeviceCaps(::GetDC(m_cSummary.m_hWnd),LOGPIXELSX);
	CHARFORMAT cfm;
	cfm.cbSize = sizeof(CHARFORMAT);
	cfm.dwMask = CFM_BOLD;
	PARAFORMAT pfm;
	pfm.cbSize = sizeof(PARAFORMAT);
	pfm.dwMask = PFM_TABSTOPS;
	HDITEM hdiDecode;
	LVITEM lviDecode;
	TCHAR retStr[100];
	hdiDecode.cchTextMax = 100;
	hdiDecode.pszText = retStr;
	lviDecode.cchTextMax = 100;
	lviDecode.pszText = retStr;

	CString sItem, sText;

	m_dlg = (CIRScopeDlg*)GetParent();

	pfm.cTabCount = m_dlg->m_Decode.GetHeaderCtrl()->GetItemCount();
	int iPos = 0;
	hdiDecode.mask = HDI_WIDTH;
	for (int i=0; i<pfm.cTabCount; i++) {
		if (m_dlg->m_Decode.GetHeaderCtrl()->GetItem(i, &hdiDecode)) {
			iPos += hdiDecode.cxy*1440/iLogX;
			pfm.rgxTabs[i] = iPos;
		}
	}
	m_cSummary.SetParaFormat(pfm);

	cfm.dwEffects = CFE_BOLD;
	Append("DECODES:\n\n", cfm);
	hdiDecode.mask = HDI_TEXT;
	sText = "";
	for (int i=0; i<pfm.cTabCount; i++) {
		if (m_dlg->m_Decode.GetHeaderCtrl()->GetItem(i, &hdiDecode)) {
			sItem = hdiDecode.pszText;
			sText += sItem.Left(100);
			if (i < pfm.cTabCount-1) sText += "\t";
			else sText += "\n";
		}
	}
	Append(sText, cfm);

	cfm.dwEffects = 0;
	sText = "";
	lviDecode.mask = LVIF_TEXT;
	for (int row=0; row< m_dlg->m_Decode.GetItemCount(); row++) {
		for (int i=0; i<pfm.cTabCount; i++) {
			lviDecode.iItem = row;
			lviDecode.iSubItem = i;
			if (m_dlg->m_Decode.GetItem(&lviDecode)) {
				sText += lviDecode.pszText;
				if (i < pfm.cTabCount-1) sText += "\t";				
			}
		}
		sText += "\n";
	}
	Append(sText, cfm);

	Signal sig;
	DecodeItem dcItem;


	pfm.cTabCount = 2;
	pfm.rgxTabs[0] = 420;
	pfm.rgxTabs[1] = 1320;
	m_cSummary.SetParaFormat(pfm);

	cfm.dwEffects = CFE_BOLD;
	Append("\nRAW TIMING DATA:\n\n", cfm);
	for (int row=0; row< m_dlg->m_Decode.GetItemCount(); row++) {
		cfm.dwEffects = CFE_BOLD;
		sItem.Format("%i:\t", row+1);
		Append(sItem, cfm);
		cfm.dwEffects = 0;
		sText = "";
		dcItem = m_dlg->m_Decodes[row];
		sig = m_dlg->m_Signals[dcItem.signalIndex];
		for (int i=2*dcItem.start; i<2*(dcItem.end+1); i++) {
			if (sig.times[i]) sItem.Format("%+i ", sig.times[i]);
			else sItem = (i&1) ? "-0 " : "+0 ";
			sText += sItem;
		}
		sText += "\n";
		Append(sText, cfm);
	}

	if (m_dlg->m_hExchangeLib) {
		int* signal_out = NULL;
		char irp[500];
		int sngl_count = 0, rpt_count = 0, extra_count = 0, rpts = 0; 
		cfm.dwEffects = CFE_BOLD;
		Append("\nANALYSED TIMING DATA:\n\n", cfm);
		for (int row=0; row< m_dlg->m_Decode.GetItemCount(); row++) {
			cfm.dwEffects = CFE_BOLD;
			sItem.Format("%i:\t", row+1);
			Append(sItem, cfm);
			cfm.dwEffects = 0;
			dcItem = m_dlg->m_Decodes[row];
			sItem.Format("%s%s%s%s\n",
				dcItem.usernote != "" ? dcItem.usernote + " : " : "",
				"Protocol="+dcItem.protocol,
				dcItem.device != "" ? "  Device="+dcItem.device : "",
				dcItem.key != "" ? "  OBC="+dcItem.key : "");
			Append(sItem, cfm);

			sig = m_dlg->m_Signals[dcItem.signalIndex];
			sngl_count = dcItem.end-dcItem.start+1;
			rpt_count = extra_count = rpts = 0;
			m_dlg->m_FindRepeat(sig.times+2*dcItem.start, sngl_count, 
				rpt_count, extra_count, rpts, m_dlg->GetErrlimit(dcItem.freq));
			signal_out = new int[2*(sngl_count+rpt_count+extra_count)];
			irp[0] = "bqx$"[m_dlg->m_iIRPformat];
			m_dlg->m_Analyze(sig.times+2*dcItem.start, sngl_count, rpt_count, 
				extra_count, rpts, signal_out, NULL, 0, m_dlg->GetErrlimit(dcItem.freq),
				dcItem.freq, irp);
			if (irp[0]) {
				Append("\tIRP form:\t"+CString(irp)+"\n", cfm);
			}

			if (sngl_count) {
				Append("\tSingle:\t", cfm);
				sText = "";
				for (int i=0; i<2*sngl_count; i++) {
					if (signal_out[i]) sItem.Format("%+i ", signal_out[i]*(1-2*(i&1)));
					else sItem = (i&1) ? "-0 " : "+0 ";
					sText += sItem;
				}
				Append(sText+"\n", cfm);
			}
			if (rpt_count) {
				Append("\tRepeat:\t", cfm);
				sText = "";
				for (int i=2*sngl_count; i<2*(sngl_count+rpt_count); i++) {
					if (signal_out[i]) sItem.Format("%+i ", signal_out[i]*(1-2*(i&1)));
					else sItem = (i&1) ? "-0 " : "+0 ";
					sText += sItem;
				}
				Append(sText+"\n", cfm);
			}
			if (extra_count) {
				Append("\tExtra:\t", cfm);
				sText = "";
				for (int i=2*(sngl_count+rpt_count); i<2*(sngl_count+rpt_count+extra_count); i++) {
					if (signal_out[i]) sItem.Format("%+i ", signal_out[i]*(1-2*(i&1)));
					else sItem = (i&1) ? "-0 " : "+0 ";
					sText += sItem;
				}
				Append(sText+"\n", cfm);
			}
			delete [] signal_out;
			signal_out = NULL;
		}
	}

	INIT_EASYSIZE;

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}



void CIRSummary::OnBnClickedBnSaveas()
{
	// TODO: Add your control notification handler code here
	CFile file;
	CString file_name;
	EDITSTREAM es;
	CFileDialog dlg(FALSE,"*.rtf",NULL,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,
			"Rich Text Format (*.rtf)|*.rtf|Text only (*txt)|*.txt||");
	if (dlg.DoModal() == IDOK) {
		file_name = dlg.GetPathName();
		if (file.Open(file_name, CFile::modeWrite | CFile::modeCreate)) {
			es.dwCookie = (DWORD) &file;
			es.pfnCallback = SummaryOutCallback; 
			m_cSummary.StreamOut(dlg.m_ofn.nFilterIndex==1?SF_RTF:SF_TEXT, es);
		}
		else AfxMessageBox("Unable to open file");
	}
}

void CIRSummary::Append(const CString& s, CHARFORMAT& fmt)
{

	// This code is taken from:
	// http://www.flounder.com/riched20bug.htm
	// and is needed to compensate for a bug in the GetTextLength.
	// The note numbers refer to notes on that web page.
	
	CHARRANGE oldsel;
	m_cSummary.GetSel(oldsel);									//  [2]
	int oldfirstline = m_cSummary.GetTextLength();				//  [3]

	m_cSummary.SetRedraw(FALSE);  // avoid annoying flicker		//  [4]
     
	int start = m_cSummary.GetTextLength();						//  [5]
	m_cSummary.SetSel(start, start);							//  [6]

	CHARRANGE newsel;											//  [7]
	m_cSummary.GetSel(newsel);									//  [8]

	CHARRANGE highlight = newsel;								//  [8]
	m_cSummary.ReplaceSel(s);									//  [9]
     
	int end = m_cSummary.GetTextLength();						// [10]

	CHARRANGE newend = {end, end};								// [11]
	m_cSummary.SetSel(newend);									// [12]
	m_cSummary.GetSel(newend);									// [13]

	highlight.cpMax = newend.cpMax;								// [14]

	m_cSummary.SetSel(highlight.cpMin, highlight.cpMax);		// [15]

	m_cSummary.SetSelectionCharFormat(fmt);						// [16]

	if(oldsel.cpMin != newsel.cpMin || oldsel.cpMax != newsel.cpMax) // [17]
	{ /* restore selection */
		m_cSummary.SetSel(oldsel);								// [18]
		int current = m_cSummary.GetFirstVisibleLine();			// [29]
		if(current != oldfirstline)								// [20]
			m_cSummary.LineScroll(oldfirstline - current);		// [21]
	} /* restore selection */
	else
		m_cSummary.SetSel(highlight.cpMax, highlight.cpMax);	// [22]

	m_cSummary.SetRedraw(TRUE);									// [23]
	m_cSummary.Invalidate();									// [24]
} // CIRSummary::Append



void CIRSummary::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: Add your message handler code here
	UPDATE_EASYSIZE;
}

void CIRSummary::OnSizing(UINT fwSide, LPRECT pRect)
{
	CDialog::OnSizing(fwSide, pRect);

	// TODO: Add your message handler code here
	EASYSIZE_MINSIZE(450,300,fwSide,pRect);
}

void CIRSummary::OnBnClickedCheckWrap()
{
	// TODO: Add your control notification handler code here
		UpdateData(true);
		m_cSummary.SetTargetDevice(NULL, !m_bWrap);


}
