// IRScopeDlg.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CIRScopeDlg dialog

// Define current revision number for GUI.
// When different from last-used value in registry, window and control
// positions are not restored from registry.
#pragma once

#define REVISION 5

// Define list of controls whose position is saved in registry
#define CTRL_LIST {IDC_DECODE, IDC_DECODE_STRUCT, IDC_DECODE_IRP, IDC_CAPTURE, IDC_VIEW, IDC_AUTOSAVE, IDC_CLEAR_DECODE, IDC_CLEAR_BEFORE, IDC_SHOW_WAVE, IDC_STATIC_SIG, IDC_STATIC_ACT, IDC_BN_NOTE, IDC_BN_SAVEAS, IDC_BN_EXPORT, IDC_BN_DELETE, IDC_BN_UP, IDC_BN_DOWN, IDC_BN_IMPORT, IDC_BN_SUMMARY, IDC_STATIC_USERNOTE, IDC_STATIC_IRP, IDC_SAVEALLAS}
// Define option menu, list of options, their submenus and variables whose values are saved in registry
#define OPT_MENU 3
#define OPT_LIST {ID_AUTOTYPES_ICT, ID_AUTOTYPES_WAV, ID_AUTOTYPES_TVBG, ID_AUTOMODES_PROMPT, ID_AUTOWIDGET, 0, 0, ID_OPTIONS_NOBEEPS, ID_OPTIONS_HIDESAVEPANEL, ID_THUMB_FIXEDRES, ID_THUMB_LIMITEDDUR, ID_OPTIONS_SELECTONCAPTURE, ID_OPTIONS_COMMONFOLDER, ID_OPTIONS_DISABLEDECODER}
#define OPT_SUB {0, 0, 0, 1, -1, -2, -2, -1, -1, 7, 7, -1, -1, -1}
#define OPT_VAR {&m_SaveICT, &m_SaveWav, &m_SaveTVBG, &m_AskName, &m_AutoWidget, &m_ClearBeforeCapture, &m_ShowWaveform, &m_NoBeeps, &m_HideSavepanel, NULL, NULL, &m_SelectOnCapture, &m_CommonFolder, &m_DisableDecoder}
#define OPT_DEFAULT 0x150

#define EXPORT_MENU 2
#define EXPORT_DEFAULT 0

#define HELP_MENU 4
#define SETFOLDER_SUBMENU 11

#define IRPDATAFORMAT_DEFAULT 3

#include "resource.h"
#include "shlobj.h"
#include <vector>
#include "afxwin.h"
#include "IRScopeWnd.h"

using namespace std;

enum { SAVE_LAST, SAVE_SELECTED, SAVE_ALL };

typedef void (_stdcall* typeGetVersion)(char *);

typedef void (_stdcall* typeDecodeIR)(
				      int* Context, /* [2] */
				      int* bursts,
				      const int freq,
				      const int singleBurstCount,
				      const int repeatBurstCount,
				      char* protocol,	/* [64] */
				      int* device,
				      int* subDevice,
				      int* OBC,
				      int* hex,			/* [4] */
				      char* misc,		/* [64] */
				      char* error);		/* [64] */

typedef int (_stdcall* typeMakePronto)(
				      char* filename,
					  char* key,
				      int* signal_out,
				      const int freq,
				      const int singleBurstCount,
				      const int repeatBurstCount,
					  char* sPronto );

typedef int (_stdcall* typeReadPronto)(
					  int* aiPronto,
					  int& iFreq,
					  int& iSngl_count,
					  int& iRpt_count,
					  int* signal_out );

typedef int (_stdcall* typeMakeUEILearned)(
					  char* sFilename,
					  char* sKey,
					  int* signal_out, 
					  int sngl_count,
					  int rpt_count,
					  int extra_count,
					  int* bursts,
					  int bursts_count,
					  UINT iFreq,
					  BYTE* learned );

typedef int (_stdcall* typeReadUEILearned)(
					  int* aiUEI,
					  int& iFreq,
					  int& iSngl_count,
					  int& iRpt_count,
					  int& iExtra_count,
					  int* signal_out );

typedef int (_stdcall* typeMakeLintronic)(
					  char* sFilename,
					  char* sKey,
					  int* times,
					  int sngl_count,
					  int rpt_count,
					  int extra_count,
					  int rpts);

typedef void (_stdcall* typeFindRepeat)(
					  int* times, 
					  int& sngl_count, 
				  	  int& rpt_count, 
					  int& extra_count, 
					  int& rpts, 
					  int errlimit);

typedef int (_stdcall* typeAnalyze)(
				  	  int* times,
					  int sngl_count, 
					  int rpt_count,
					  int extra_count,
					  int rpts,
					  int* signal_out,
					  int* bursts,
					  int bursts_size,
					  int errlimit,
					  int freq,
					  char* irp);

typedef int (_stdcall* typeMakeHex)(
					  char* sOutFile,
					  char* sIRPFile,
					  char* sKey,	
					  char* device,
					  char* OBC);

static CString strSavePath;
static CString strExportPath;
static CString strIRPPath;
static CString strViewPath;

const CString m_Notes[] = {
	"One frame.",
	"%i identical frames.",
	"%i frames with lead-in on only the first frame.",
	"Main frame with %i ditto frames.",
	"%i frames including distinctive start frame.",
	"%i frames including distinctive end frame.",
	"%i frames including distinctive start and end frames.",
	"%i frames alternating main and check frames.",
	"A generic decode of an unknown protocol",
	"One frame with lead-in.",
	"Main frame with one ditto frame.",
	"%i frames with extended lead-in on the first frame.",
	"Unknown protocol."};

const CString m_AuxNotes[] = {
	"  Incomplete signal: expected end frame missing.",
	"  Incomplete signal: expected start frame missing.",
	"  Incomplete signal: expected start and end frames missing.",
	"  Incomplete signal: main frame without check frame.",
	"  Incomplete signal: check frame without preceding main frame.",
	"  Incomplete signal: start frame with no following frames.",
	"  Incomplete signal: end frame with no preceding frames."};

struct Burst
{
	int times[2];
	double totals[2];
	short count;

	Burst()
	{
		times[0] = 0;
		times[1] = 0;
		totals[0] = 0.;
		totals[1] = 0.;
		count = 0;
	};

	Burst(int iOn, int iOff)
	{
		times[0] = abs(iOn);
		times[1] = abs(iOff);
		totals[0] = 0.;
		totals[1] = 0.;
		count = 0;
	};

	~Burst()
	{};
};

struct DecodeItem
{
	int start;
	int end;
	int note;
	int param;
	int auxNote;
	int freq;
	int signalIndex;
	CString protocol;
	CString device;
	CString key;
	CString hex;
	CString misc;
	CString error;
	CString usernote;

	DecodeItem()
	{
		start = 0;
		end = 0;
		note = 0;
		param = 0;
		auxNote = 0;
		freq = 0;
		signalIndex = -1;
		protocol = "";
		device = "";
		key = "";
		hex = "";
		misc = "";
		error = "";
		usernote = "";
	};

	DecodeItem(
		int iSignalIndex,
		int iStart,
		int iEnd) 
	{
		start = iStart;
		end = iEnd;
		note = 0;
		param = 0;
		auxNote = 0;
		freq = 0;
		signalIndex = iSignalIndex;
		protocol = "";
		device = "";
		key = "";
		hex = "";
		misc = "";
		error = "";
		usernote = "";
	};

	DecodeItem(
		int iSignalIndex,
		int iStart,
		int iEnd,
		int iNote,
		int iParam,
		int iAuxNote) 
	{
		start = iStart;
		end = iEnd;
		note = iNote;
		param = iParam;
		auxNote = iAuxNote;
		freq = 0;
		signalIndex = iSignalIndex;
		protocol = "";
		device = "";
		key = "";
		hex = "";
		misc = "";
		error = "";
		usernote = "";
	};

	~DecodeItem()
	{};
};

struct Signal
{
	CWnd* wnd; // Waveform window displaying signal
	int* times;
	short int* counts;
	UINT timesCnt;
	int freq;

	Signal()
	{
		wnd = NULL;
		times = NULL;
		counts = NULL;
		timesCnt = 0;
		freq = 0;
	};

	Signal(
		CWnd* wWnd,
		int* piTimes,
		short int* piCounts,
		UINT uTimesCnt,
		int iFreq)
	{
		int i;
		wnd = wWnd;
		times = new int[uTimesCnt];
		for (i = 0; i < uTimesCnt; i++) times[i] = piTimes[i];
		if (piCounts != NULL)
		{
			counts = new short[uTimesCnt];
			for (i = 0; i < uTimesCnt; i++) counts[i] = piCounts[i];
		}
		else counts = NULL;
		timesCnt = uTimesCnt;
		freq = iFreq;
	};

	void done()
	{
//		AfxMessageBox("Freeing signal memory");
		if (times != NULL) delete [] times;
		if (counts != NULL) delete [] counts;
		wnd = NULL;
		times = NULL;
		counts = NULL;
		timesCnt = 0;
		freq = 0;
	};

	~Signal()
	{};
};

struct UserNote
{
	int burst;
	CString note;

	UserNote()
	{
		burst = 0;
		note = "";
	};

	UserNote(
		int iBurst,
		CString sNote )
	{
		burst = iBurst;
		note = sNote;
	};

	~UserNote()
	{};
};

class CIRScopeDlg : public CDialog
{
// Construction
public:
	CIRScopeDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CIRScopeDlg)
	enum { IDD = IDD_IRSCOPE_DIALOG };
	CListCtrl	m_Decode;
	UINT	m_Duration;
	CString	m_Port;
	int		m_Hardware;
	BOOL	m_SaveICT;
	BOOL	m_SaveTVBG;
	BOOL	m_SaveWav;
	BOOL	m_AskName;
	BOOL	m_ClearBeforeCapture;
	BOOL	m_ShowWaveform;
	vector<DecodeItem> m_Decodes;
	vector<Burst> m_Bursts;
	vector<Signal> m_Signals;
	vector<UserNote> m_UserNotes;
	vector<int> m_viSelected;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CIRScopeDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation

public:
	CWnd* m_currentWnd;
	HACCEL m_hAccel;			// GD
	CString command_line_filename;
	CString REG_KEY_SET;
	int m_iThumbScale;
	int m_iExportMode;
	int m_iIRPformat;
	int m_count;
	int* m_times;
	UINT m_freq;
	int m_errlimit;
	short int* m_counts;

	HINSTANCE m_hDecodeLib;
	HINSTANCE m_hExchangeLib;
	HINSTANCE m_hFTDILib;
	HINSTANCE m_hMakeHexLib;

	void OpenICTFile(LPCTSTR file_name);
	LRESULT OnOpenICTFile(WPARAM wParam, LPARAM lParam);
	void SetCommandLine ( LPCTSTR aCommand );
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	typeFindRepeat m_FindRepeat;
	typeAnalyze m_Analyze;
	typeReadPronto m_ReadPronto;
	typeReadUEILearned m_ReadUEILearned;
	int GetErrlimit(int freq);
	CString MakeIRP(DecodeItem dcItem);

	DECLARE_MESSAGE_MAP()
	DECLARE_EASYSIZE									// GD

protected:
	HICON m_hIcon;
	typeGetVersion m_GetDecodeVersion;
	typeGetVersion m_GetExchangeVersion;
	typeGetVersion m_GetMakeHexVersion;
	typeDecodeIR m_DecodeIR;
	typeMakePronto m_MakePronto;
	typeMakeUEILearned m_MakeUEILearned;
	typeMakeLintronic m_MakeLintronic;
	typeMakeHex m_MakeHex;


	UINT WriteTVBGFile(LPCSTR filename, int count, int *times, UINT freq);
	int WriteWavFile(LPCSTR filename, int count, int *times, UINT freq);
	void Decode(int count, int *times, short int *counts, 
		UINT freq, int signalIndex, BOOL capture);
	virtual BOOL OnInitDialog();

	// Generated message map functions
	//{{AFX_MSG(CIRScopeDlg)
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnCapture();
	afx_msg void OnView();
	afx_msg void OnClearDecode();
	afx_msg void OnDestroy();
	//}}AFX_MSG
	afx_msg void OnSize(UINT nType, int cx, int cy);	// GD
	afx_msg void OnSizing(UINT nSide, LPRECT lpRect);	// GD

	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnFileOpen();
	afx_msg void OnFileSave();
	afx_msg void OnFileClear();
	afx_msg void OnFileCapture();
	afx_msg void OnFileSetsavefolder();
	afx_msg void OnFileSetexportfolder();
	afx_msg void OnAppAbout();
	afx_msg void OnFileSaveAs();
	afx_msg void OnAutotypesIct();
	afx_msg void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
	afx_msg void OnNMClickDecode(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnCbnSelchangeHardware();
	afx_msg void OnAutotypesWav();
	afx_msg void OnAutotypesTvbg();
	afx_msg void OnAutomodes(UINT nID);
	afx_msg void OnBnClickedSaveIct();
	afx_msg void OnBnClickedSaveWav();
	afx_msg void OnBnClickedSaveTvbg();
	afx_msg void OnBnClickedAskName();
	afx_msg void OnBnClickedBnExport();
	afx_msg void OnAutowidget();
	afx_msg void OnOptionsNobeeps();
	afx_msg void OnOptionsHidesavepanel();
	afx_msg void OnThumbScale(UINT nID);
	afx_msg void OnExportMode(UINT nID);
	afx_msg void OnNMRClickDecode(NMHDR *pNMHDR, LRESULT *pResult);
//	afx_msg void OnFileSaveSelected();
	afx_msg void OnFileSaveSelectedAs();
	afx_msg void OnHelpDecodeirHtml();
	afx_msg void OnExportExport();
	afx_msg void OnExportExportselected();
	afx_msg void OnNMDblclkDecode(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedBnDelete();
	afx_msg void OnBnClickedBnNote();
	afx_msg void OnBnClickedBnUp();
	afx_msg void OnBnClickedBnDown();
	afx_msg void OnBnClickedBnSave();
	afx_msg void OnBnClickedBnSaveas();
	afx_msg void OnFileSetirpfolder();
	afx_msg void OnOptionsSelectOnCapture();
	afx_msg void OnFileSummary();
	afx_msg void OnBnClickedBnImport();
	afx_msg void OnOptionsCommonfolder();
	afx_msg void OnOptionsDisabledecoder();
	afx_msg void OnIrpdataformat(UINT nID);

private:
	int m_bRestore;
	BOOL m_AutoWidget;
	BOOL m_NoBeeps;
	BOOL m_HideSavepanel;
	BOOL m_bAutolocated;
	BOOL m_CommonFolder;
	BOOL m_DisableDecoder;
	CStatic m_AutoSaveNote;
	CString m_sAppFolder;
	BOOL m_SelectOnCapture;

	void UpdateMenu(CMenu* pMenu);
	UINT GetFreq(int start, int end);
	void SetAvailablePorts(int hardware);
	void ToggleMenuOption(UINT nID, BOOL* statevar, int ndx, int force = -1);
	void CopyBtnToMenu(UINT btnID, UINT menuID);
	void SaveICTFile(CString file_name, int mode);
	void OnFileSaveCommon(int mode);
	void OnFileSaveAsCommon(int mode);
	void OnExportCommon(BOOL bSelected);
	void DeselectAll();
	void SelectDecode(BOOL bRedLine);
	void DeleteDecode();
	void ExportDecode(size_t row);
	void RefreshDecode(void);
	int GetSelectedDecodes(void);
	void SelectAll(void);
	void SetSelectedDecodes(int offset);
	void DefocusAll(void);
	void ClearRedline(void);
	CString ProtocolToIRP(CString protocol);
	CString GetNote(int start, int end);
	CIrScopeWnd* CreateWaveform(CString sName, int sigIndex);

public:

static int __stdcall CALLBACK SaveCallbackProc(HWND hwnd, UINT umsg, LPARAM lparam, LPARAM lpData)
{
	CString str;
	if (umsg == BFFM_INITIALIZED)
	{
		::SendMessage(hwnd, BFFM_SETSELECTION, TRUE, (LPARAM)strSavePath.GetBuffer(0));
	}
	else if (umsg == BFFM_VALIDATEFAILED)
	{
		str.Format("The path %s is not valid.  Please try again.", (char*)lparam);
		AfxMessageBox(str);
		return 1;
	}
	return 0;
}

static int __stdcall CALLBACK ExportCallbackProc(HWND hwnd, UINT umsg, LPARAM lparam, LPARAM lpData)
{
	CString str;
	if (umsg == BFFM_INITIALIZED)
	{
		::SendMessage(hwnd, BFFM_SETSELECTION, TRUE, (LPARAM)strExportPath.GetBuffer(0));
	}
	else if (umsg == BFFM_VALIDATEFAILED)
	{
		str.Format("The path %s is not valid.  Please try again.", (char*)lparam);
		AfxMessageBox(str);
		return 1;
	}
	return 0;
}

static int __stdcall CALLBACK IRPCallbackProc(HWND hwnd, UINT umsg, LPARAM lparam, LPARAM lpData)
{
	CString str;
	if (umsg == BFFM_INITIALIZED)
	{
		::SendMessage(hwnd, BFFM_SETSELECTION, TRUE, (LPARAM)strIRPPath.GetBuffer(0));
	}
	else if (umsg == BFFM_VALIDATEFAILED)
	{
		str.Format("The path %s is not valid.  Please try again.", (char*)lparam);
		AfxMessageBox(str);
		return 1;
	}
	return 0;
}
	
afx_msg void OnBnClickedSaveallas();
afx_msg void OnFileSaveallas();
}; // class CIRScopeDlg : public CDialog


