// IRScope.cpp : Defines the class behaviors for the application.
//

/*
    Copyright (C) 2007 Kevin Timmerman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


#include "stdafx.h"
#include "IRScope.h"
//#include "IRScopeWnd.h"
#include "IRScopeDlg.h"
#include <afxadv.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIRScopeApp

BEGIN_MESSAGE_MAP(CIRScopeApp, CWinApp)
	//{{AFX_MSG_MAP(CIRScopeApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
//	ON_COMMAND(ID_FILE_OPEN, CIRScopeDlg::OnView)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIRScopeApp construction

CIRScopeApp::CIRScopeApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CIRScopeApp object

CIRScopeApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CIRScopeApp initialization

BOOL CIRScopeApp::InitInstance()
{
//TODO: call AfxInitRichEdit2() to initialize richedit2 library.
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// GUID for IRScope Single Instance generated by MS GUIDGen.exe
	if ( CSingleInstance::Create (_T("{D474ECAE-E923-4d17-B4DC-CBDC5352E68E}"))
		== FALSE )
      return FALSE ;

	// Next line creates registry key HKEY_CURRENT_USER\Software\UEIC\<filename> 
	// with subkeys Recent File List and Settings.  The UEIC key is that used
	// by IR.exe, so all IR stuff is kept in one place.
	SetRegistryKey("UEIC");
	LoadStdProfileSettings(6);	// Keep 6 files in recent files list

	// Extract into exeName the body of the filename (no path, no extension)
	// used as <filename> above.
	CString exeName;
	TCHAR exe_name[MAX_PATH];
	GetModuleFileName(NULL, exe_name, MAX_PATH);
	exeName = exe_name;
	exeName = exeName.Right(exeName.GetLength() - exeName.ReverseFind((TCHAR)('\\')) - 1);
	if (exeName.Right(exeName.GetLength() - exeName.ReverseFind((TCHAR)('.'))) == ".exe")
		exeName = exeName.Left(exeName.GetLength() - 4);

	CIrScopeWnd::RegisterWndClass();

	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	CIRScopeDlg dlg;
	m_pMainWnd = &dlg;

	// Set REG_KEY_SET to be the subkey of HKEY_CURRENT_USER used for Settings
	dlg.REG_KEY_SET = "Software\\UEIC\\" + exeName + "\\Settings";
	// Check that it exists (it should have just been created if it did not)
	// by opening it, then closing it if successful.
	HKEY hkey;
	if (RegOpenKeyEx(HKEY_CURRENT_USER, dlg.REG_KEY_SET,
			0, KEY_QUERY_VALUE, &hkey) == ERROR_SUCCESS)
	{
		RegCloseKey(hkey);
	}
	else
	{
		dlg.REG_KEY_SET = "Software\\UEIC\\IRScope\\Settings";
	}

	if (cmdInfo.m_nShellCommand == CCommandLineInfo::FileOpen) 
		dlg.command_line_filename = cmdInfo.m_strFileName;
	else
		dlg.command_line_filename = "";

	int nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}

int CIRScopeApp::ExitInstance() 
{
	// Next line moved to CIRScopeDlg::OnDestroy() as saving of recent file
	// list crashes if waveform windows are closed this late.

	// CIrScopeWnd::CloseAll();
	
	return CWinApp::ExitInstance();
}

CDocument* CIRScopeApp::OpenDocumentFile(LPCTSTR lpszFileName)
{
	// TODO: Add your specialized code here and/or call the base class

	/*
	We need to return a non null value otherwise the most recent file will be 
	deleted from the menu.  If the calling function is the 
	CWinApp::OnOpenRecentFile it will not use the return value, so it is safe to 
	return a bogus value.
	*/
	m_pMainWnd->SendMessage(WM_OPEN_DLG_FILE, 0, (LPARAM) lpszFileName);
	return((CDocument*) 1); // CWinApp::OpenDocumentFile(lpszFileName);
}

void CIRScopeApp::WakeUp (LPCTSTR aCommandLine ) const
{

   // Call parent class to handle the basic
   // functionality, (set foreground)
   CSingleInstance::WakeUp ( aCommandLine ) ;       

   // Process command line, for this sample send
   // new command line to the dialog
   CIRScopeDlg* lSingletonDlg = (CIRScopeDlg*) m_pMainWnd ;

   if ( lSingletonDlg )
   {
      lSingletonDlg -> SetCommandLine ( aCommandLine ) ;
   }
}

int CIRScopeApp::DeleteMRU(BOOL del)
{
	if (del) m_pRecentFileList->Remove(0);
	return m_pRecentFileList->GetSize();
}


