// IRNoteEdit.cpp : implementation file
//

/*
	Copyright (C) 2010 Graham Dixon

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "stdafx.h"
#include "IRScopeDlg.h"
#include "IRNoteEdit.h"


// CIRNoteEdit dialog

// IMPLEMENT_DYNAMIC(CIRNoteEdit, CDialog)

CIRNoteEdit::CIRNoteEdit(CWnd* pParent /*=NULL*/)
	: CDialog(CIRNoteEdit::IDD, pParent)
	, m_sEditNote(_T(""))
	, m_sEditPrompt(_T(""))
	, m_dlg(NULL)
	, m_rowIndex(0)
{
}

CIRNoteEdit::~CIRNoteEdit()
{
}

void CIRNoteEdit::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_NOTE, m_EditNote);
	DDX_Text(pDX, IDC_EDIT_NOTE, m_sEditNote);
	DDX_Text(pDX, IDC_EDIT_PROMPT, m_sEditPrompt);
	DDX_Control(pDX, IDC_BN_DOWN, m_bnDown);
	DDX_Control(pDX, IDC_BN_UP, m_bnUp);
}


BEGIN_MESSAGE_MAP(CIRNoteEdit, CDialog)
	ON_BN_CLICKED(IDC_BN_DOWN, &CIRNoteEdit::OnBnClickedBnDown)
	ON_BN_CLICKED(IDC_BN_SAVE, &CIRNoteEdit::OnBnClickedBnSave)
	ON_BN_CLICKED(IDC_BN_UP, &CIRNoteEdit::OnBnClickedBnUp)
END_MESSAGE_MAP()


// CIRNoteEdit message handlers

BOOL CIRNoteEdit::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	m_dlg = (CIRScopeDlg*)GetParent();
	m_rowIndex = 0;
	SetRow();
	return FALSE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CIRNoteEdit::SetRow()
{
	CString s;
	int row = m_dlg->m_viSelected[m_rowIndex];
	s.Format("Note for decode #%i:", row+1);
	m_sEditPrompt = s;
	m_sEditNote = m_dlg->m_Decodes[row].usernote;
	m_bnUp.EnableWindow(m_rowIndex > 0);
	m_bnDown.EnableWindow(m_rowIndex < m_dlg->m_viSelected.size()-1);
	UpdateData(false);
	m_EditNote.SetFocus();
}

void CIRNoteEdit::OnBnClickedBnSave()
{
	// TODO: Add your control notification handler code here
	int row = m_dlg->m_viSelected[m_rowIndex];
	UpdateData(true);
	m_dlg->m_Decodes[row].usernote = m_sEditNote;
	m_dlg->m_Decode.SetItemText(row,6,m_sEditNote);
	m_dlg->UpdateWindow();
	if (m_rowIndex < m_dlg->m_viSelected.size()-1)
	{
		m_rowIndex++;
		SetRow();
	}
	else EndDialog(0);
}

void CIRNoteEdit::OnBnClickedBnUp()
{
	// TODO: Add your control notification handler code here
	m_rowIndex--;
	SetRow();
}

void CIRNoteEdit::OnBnClickedBnDown()
{
	// TODO: Add your control notification handler code here
	m_rowIndex++;
	SetRow();
}

