// IRImport.cpp : implementation file
//

/*
	Copyright (C) 2010 Graham Dixon

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*/

#include "stdafx.h"
#include "IRScopeDlg.h"
#include "IRImport.h"


// CIRImport dialog

//IMPLEMENT_DYNAMIC(CIRImport, CDialog)

CIRImport::CIRImport(CWnd* pParent /*=NULL*/)
	: CDialog(CIRImport::IDD, pParent)
	, m_sImport(_T(""))
	, m_rbFormat(0)
	, m_iRepeat(0)
	, m_dlg(NULL)
	, m_sFreq(_T(""))
{

}

CIRImport::~CIRImport()
{
}

void CIRImport::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_IMPORT, m_sImport);
	DDX_Control(pDX, IDC_COMBO_REPEAT, m_cbRepeat);
	DDX_Radio(pDX, IDC_RADIO_PRONTO, m_rbFormat);
	DDX_Control(pDX, IDC_EDIT_IMPORT, m_cImport);
	DDX_Text(pDX, IDC_EDIT_FREQ, m_sFreq);
}


BEGIN_MESSAGE_MAP(CIRImport, CDialog)
	ON_CBN_SELCHANGE(IDC_COMBO_REPEAT, &CIRImport::OnCbnSelchangeComboRepeat)
	ON_BN_CLICKED(IDCANCEL, &CIRImport::OnBnClickedCancel)
	ON_BN_CLICKED(IDC_RADIO_PRONTO, &CIRImport::OnBnClickedRadioFormat)
	ON_BN_CLICKED(IDC_RADIO_UEILEARNED, &CIRImport::OnBnClickedRadioFormat)
	ON_BN_CLICKED(IDC_RADIO_TIMING, &CIRImport::OnBnClickedRadioFormat)
END_MESSAGE_MAP()


// CIRImport message handlers

BOOL CIRImport::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_dlg = (CIRScopeDlg*)GetParent();
	CString s;
	for (int i=0; i<9; i++) {
		s.Format("%i", i);
		m_cbRepeat.AddString(s);
	}

	m_cbRepeat.SetCurSel(3);
	OnCbnSelchangeComboRepeat();

	m_rbFormat = (m_dlg->m_hExchangeLib) ? 0 : 2;
	OnBnClickedRadioFormat();

	m_cImport.SetFocus();

	// TODO:  Add extra initialization here

	return FALSE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CIRImport::OnCbnSelchangeComboRepeat()
{
	// TODO: Add your control notification handler code here
	m_iRepeat = m_cbRepeat.GetCurSel();
}

void CIRImport::OnOK()
{
	// TODO: Add your specialized code here and/or call the base class

	TCHAR ch;
	int count=0, digitCount = 0, n=0, sgn = 0;
	int* data = NULL;
	int* signal_out = NULL;
	bool isDigit = false, isOK = true, newsect = true;
	const CString validChars = CString("0123456789ABCDEF \r\n\t-+;");


	CString str;
	UpdateData(true);
	// Set base of number system in import (hex or decimal).
	int base = (m_rbFormat<2) ? 16 : 10;
	m_sImport.MakeUpper();
	// Count the hex values
	for (int i=0; i<m_sImport.GetLength(); i++) {
		// isDigit refers to previous character.
		ch = m_sImport[i];
		n = validChars.Find(ch);
		if (n < 0 || n>=base && n<16 || base!=10 && n>19) {
			if (m_rbFormat==2) {
				// The syntax of CompareNoCase requires the ! to return the expected true/false value.
				if (i+6 < m_sImport.GetLength() && !m_sImport.Mid(i,7).CompareNoCase("Single:")) {
					i += 6;
					newsect = true;
				}
				else if (i+6 < m_sImport.GetLength() && !m_sImport.Mid(i,7).CompareNoCase("Repeat:")) {
					i += 6; 
					newsect = true;
				}
				else if (i+5 < m_sImport.GetLength() && !m_sImport.Mid(i,6).CompareNoCase("Extra:")) {
					i += 5; 
					newsect = true;
				}
				else {
					AfxMessageBox("Section separators in timing list have invalid format.");
					return;
				}
			} else {
				AfxMessageBox("Invalid character \"" 
					+ m_sImport.Mid(i,1) + "\" in data.");
				return;
			}
		}
		else if (!isDigit && n<base) {	// Start of a new numeric value.
			if (m_rbFormat==2) {
				sgn = (i>0) ? CString("-+").Find(m_sImport[i-1]) : -1;
				if (sgn < 0) {
					// In a timing list, each value must be preceded by + or -
					AfxMessageBox("The data is not in Timing List format.");
					return;
				}
				if (newsect) {
					if (count&1) count += 2;	// round counter to next odd number
					else count++;
					newsect = false;
				}
				if ( sgn != (count&1) ) {
					// sign of value does not match that required for current time
					count++;
				}
			} else {
				count++;
			}
		}
		isDigit = (n >= 0 && n<base);
		// isDigit now refers to current character.
		if (isDigit) {
			digitCount++;
		}
		if (digitCount > 0 && (!isDigit || i==m_sImport.GetLength()-1)) {	// End of a numeric value.
			switch (m_rbFormat) {
			case 0: // Pronto
				if (digitCount != 4) {
					AfxMessageBox("The data is not in Pronto format.", MB_OK | MB_ICONEXCLAMATION);
					return;
				}
				break;
			case 1:  // UEI Learned
				if (digitCount != 2) {
					AfxMessageBox("The data is not in UEI Learned format.", MB_OK | MB_ICONEXCLAMATION);
					return;
				}
				break;
			case 2:	// Timing List
				// Format already checked.
				break;
			default:
				AfxMessageBox("Unrecognised import format.", MB_OK | MB_ICONEXCLAMATION);
				return;
			}
			digitCount = 0;
		}
	}

	if (count == 0) {
		AfxMessageBox("No data to import.");
		return;
	}

	int iSngl_count=0, iRpt_count=0, iExtra_count=0, iFreq = 0;

	if (m_rbFormat == 2) {
		if (m_sFreq.GetLength() == 0) {
			AfxMessageBox("A frequency must be entered when import mode is Timing List");
			return;
		} else for (int i=0; i<m_sFreq.GetLength(); i++) {
			n = CString("0123456789").Find(m_sFreq[i]);
			if (n<0) {
				AfxMessageBox("Invalid character in frequency.");
				return;
			}
			iFreq = 10*iFreq + n;
		}
	}

	data = new int[count];	// allocate memory for numeric data
	int index, iVal;
	for (index = 0; index<count; index++) data[index]=0;
	index = -1;
	isDigit = false;
	newsect = true;

	for (int i=0; i<m_sImport.GetLength(); i++) {
		// isDigit refers to previous character.
		ch = m_sImport[i];
		n = validChars.Find(ch);
		if (m_rbFormat==2 && (n < 0 || n>=base && n<16)) {
			newsect = true;
			if (i+6 < m_sImport.GetLength() && !m_sImport.Mid(i,7).CompareNoCase("Single:")) {
				i += 6;
			}
			else if (i+6 < m_sImport.GetLength() && !m_sImport.Mid(i,7).CompareNoCase("Repeat:")) {
				i += 6;
				iSngl_count = (index+2)/2;
				if (iSngl_count == 0) iSngl_count = -1;
			}
			else if (i+5 < m_sImport.GetLength() && !m_sImport.Mid(i,6).CompareNoCase("Extra:")) {
				i += 5;
				iRpt_count = (index+2)/2 - max(iSngl_count, 0);
				if (iSngl_count == 0) iSngl_count = -1;
				if (iRpt_count == 0) iRpt_count = -1;
			}
		}
		else if (!isDigit && n<base) {	// start of new numeric value
			if (m_rbFormat==2) {
				sgn = CString("-+").Find(m_sImport[i-1]);
				if (newsect) {
					if (index&1) index++;	// round index to next even number
					else index += 2;
					newsect = false;
				}
				if ( sgn == (index&1) ) {
					// sign of value does not match that required for current time
					index++;
				}
			} else {
				index++;
			}
			iVal = 0;
		}

		if (n>=0 && n<base) {
			iVal = base*iVal + n;
		}
		if (iVal > 0 && (isDigit && (n<0 || n>=base) || (n>=0 && n<base) && i==m_sImport.GetLength()-1)) {
			data[index] += iVal;
		}
		isDigit = (n>=0 && n<base);
		// isDigit now refers to current character.
	}

	int iRet, iLen;
	int iRpts = m_iRepeat;

	switch (m_rbFormat) {
	case 0:	// Pronto
		iSngl_count = count;	// Size of data array
		iLen = m_dlg->m_ReadPronto(data, iFreq, iSngl_count, iRpt_count, NULL);
		if (iLen <= 0) {
			isOK = false;
			switch (-iLen) {
				case -1:
					AfxMessageBox("Pronto format either invalid or not yet supported");
					break;
				case -2:
					AfxMessageBox("Internal error in data tables");
					break;
				default:
					AfxMessageBox("Unknown error");
			}
		} else {
			// Reserve enough memory for signal
			signal_out = new int[iLen];
			iSngl_count = count;	// Reset size of data array
			// There should not be an error this time, so don't check
			m_dlg->m_ReadPronto(data, iFreq, iSngl_count, iRpt_count, signal_out);
			iExtra_count = 0;
		}
		break;
	case 1:	// UEI Learned
		iSngl_count = count;	// Size of data array
		iLen = m_dlg->m_ReadUEILearned(data, iFreq, iSngl_count, iRpt_count, iExtra_count, NULL);
		if (iLen < 0) {
			switch (-iLen) {
			case 1:
				AfxMessageBox("Error constructing burst table.");
				break;
			case 2:
				AfxMessageBox("Attempt to read beyond end of burst table.");
				break;
			case 3:
				AfxMessageBox("Cannot import as data length inconsistent with data content");
				break;
			default:
				AfxMessageBox("Unknown error in importing UEI Learned signal.");
			}
			isOK = false;
			break;
		}
		signal_out = new int[iLen];
		iSngl_count = count;	// Reset size of data array
		iRet = m_dlg->m_ReadUEILearned(data, iFreq, iSngl_count, iRpt_count, iExtra_count, signal_out);
		if (iRet < 0) {
			isOK = false;
			break;
		}
		break;
	case 2:	// Timed List
		if (iSngl_count == 0) iSngl_count = (index+2)/2;
		else if (iRpt_count == 0) iRpt_count = (index+2)/2 - max(iSngl_count, 0);
		else iExtra_count = (index+2)/2 - max(iSngl_count, 0) - max(iRpt_count, 0);
		if ( iRpt_count < 0 ) {
			iSngl_count = max(iSngl_count, 0) + iExtra_count;
			iRpt_count = 0;
			iExtra_count = 0;
		} else if ( iSngl_count < 0 ) {
			iSngl_count = 0;
		}
		signal_out = data;
		iLen = count;
		data = NULL;
		break;
	default:
		AfxMessageBox("Unknown import format");
		isOK = false;
	}

	if (isOK) {
		// No errors so perform the import.
		m_dlg->m_UserNotes.clear();
		m_dlg->m_times = NULL;			
		m_dlg->m_count = 2*(iSngl_count+iRpts*iRpt_count+iExtra_count);
		m_dlg->m_times = new int[m_dlg->m_count];
		m_dlg->m_counts = new short[m_dlg->m_count];		
		m_dlg->m_freq = iFreq;

		index = 0;
		// Make sure we don't run past the end of signal_out
		for (int i=0; i<2*iSngl_count; i++) {
			m_dlg->m_times[index++] = (i<iLen) ? signal_out[i]*(1-2*(i&1)) : 0;
		}

		for (int j=0; j<iRpts; j++) {
			for (int i=2*iSngl_count; i<2*(iSngl_count+iRpt_count); i++) {
				m_dlg->m_times[index++] = (i<iLen) ? signal_out[i]*(1-2*(i&1)) : 0;
			}
		}
		for (int i=2*(iSngl_count+iRpt_count); i<2*(iSngl_count+iRpt_count+iExtra_count); i++) {
			m_dlg->m_times[index++] = (i<iLen) ? signal_out[i]*(1-2*(i&1)) : 0;
		}

		if (m_dlg->m_freq > 0) {		
			for (int i=0; i<m_dlg->m_count; i++) {
				m_dlg->m_counts[i] = m_dlg->m_times[i]>0 ? int(m_dlg->m_times[i]*m_dlg->m_freq/1000000. + 0.5) : 0;
			}
		} else {
			for (int i=0; i<m_dlg->m_count; i++) {
				m_dlg->m_counts[i] = m_dlg->m_times[i]>0 ? 1 : 0;
			}
		}
	}

	delete [] data;
	data = NULL;
	delete [] signal_out;
	signal_out = NULL;
	if (isOK) {
		EndDialog(IDOK);
	}

//	CDialog::OnOK();
}

void CIRImport::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here
	OnCancel();
}

void CIRImport::OnBnClickedRadioFormat()
{
	// TODO: Add your control notification handler code here
	UpdateData(true);
	GetDlgItem(IDC_STATIC_FREQ)->EnableWindow(m_rbFormat==2);
	GetDlgItem(IDC_STATIC_HZ)->EnableWindow(m_rbFormat==2);
	GetDlgItem(IDC_EDIT_FREQ)->EnableWindow(m_rbFormat==2);
}

